program threadinterrupt;

{$APPTYPE CONSOLE}

//
// This example demonstrates how to raise an ThreadInterruptedException in
// another thread. 
//
// Written by: Rick Ross (http://www.rick-ross.com)
//

uses System.Threading;

type
  TMyThread = class
  public
    procedure MyThreadMethod;  
  end;

procedure TMyThread.MyThreadMethod;
begin
  System.Console.WriteLine('Staring MyThreadMethod...');
  try
    System.Console.WriteLine('Resting for a while..');
    Thread.Sleep(Timeout.Infinite);
    System.Console.WriteLine('This will never be seen!');
  except
    on e : System.Threading.ThreadInterruptedException do
    begin
      System.Console.WriteLine('thread has been interrupted!');        
    end;
  end;

  System.Console.WriteLine('Yawn...Why did you wake me up?');
end;

var
  tc : TMyThread;
  t  : Thread;

begin
  System.Console.WriteLine('Starting up...');
  tc := TMyThread.Create;
  System.Console.WriteLine('creating thread...'); 
  t := Thread.Create( @tc.MyThreadMethod );  
  System.Console.WriteLine('Press ENTER to interrupt the thread from its nap!');

  t.Start();

  readln;
  t.Interrupt();
end.

